import { jsx } from "react/jsx-runtime";
import { useEditor } from "@tldraw/editor";
import { useCallback, useRef } from "react";
import { useUiEvents } from "../../context/events.mjs";
import { TldrawUiInput } from "../primitives/TldrawUiInput.mjs";
const PageItemInput = function PageItemInput2({
  name,
  id,
  isCurrentPage
}) {
  const editor = useEditor();
  const trackEvent = useUiEvents();
  const rInput = useRef(null);
  const handleFocus = useCallback(() => {
    editor.mark("rename page");
  }, [editor]);
  const handleChange = useCallback(
    (value) => {
      editor.renamePage(id, value || "New Page");
      trackEvent("rename-page", { source: "page-menu" });
    },
    [editor, id, trackEvent]
  );
  return /* @__PURE__ */ jsx(
    TldrawUiInput,
    {
      className: "tlui-page-menu__item__input",
      ref: (el) => rInput.current = el,
      defaultValue: name,
      onValueChange: handleChange,
      onFocus: handleFocus,
      shouldManuallyMaintainScrollPositionWhenFocused: true,
      autoFocus: isCurrentPage,
      autoSelect: true
    }
  );
};
export {
  PageItemInput
};
//# sourceMappingURL=PageItemInput.mjs.map
