import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import { useActions } from "../../context/actions.mjs";
import {
  useCanRedo,
  useCanUndo,
  useIsInSelectState,
  useUnlockedSelectedShapesCount
} from "../../hooks/menu-hooks.mjs";
import { useReadonly } from "../../hooks/useReadonly.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
function DefaultQuickActionsContent() {
  const actions = useActions();
  const editor = useEditor();
  const canUndo = useCanUndo();
  const canRedo = useCanRedo();
  const oneSelected = useUnlockedSelectedShapesCount(1);
  const isReadonlyMode = useReadonly();
  const isInAcceptableReadonlyState = useValue(
    "should display quick actions",
    () => editor.isInAny("select", "hand", "zoom"),
    [editor]
  );
  const isInSelectState = useIsInSelectState();
  const selectDependentActionsEnabled = oneSelected && isInSelectState;
  if (isReadonlyMode && !isInAcceptableReadonlyState) return;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["undo"], disabled: !canUndo }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["redo"], disabled: !canRedo }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["delete"], disabled: !selectDependentActionsEnabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["duplicate"], disabled: !selectDependentActionsEnabled })
  ] });
}
export {
  DefaultQuickActionsContent
};
//# sourceMappingURL=DefaultQuickActionsContent.mjs.map
