import { jsx } from "react/jsx-runtime";
import { useEditor } from "@tldraw/editor";
import classNames from "classnames";
import { memo, useCallback } from "react";
import { useRelevantStyles } from "../../hooks/useRelevantStyles.mjs";
import { DefaultStylePanelContent } from "./DefaultStylePanelContent.mjs";
const DefaultStylePanel = memo(function DefaultStylePanel2({
  isMobile,
  children
}) {
  const editor = useEditor();
  const styles = useRelevantStyles();
  const handlePointerOut = useCallback(() => {
    if (!isMobile) {
      editor.updateInstanceState({ isChangingStyle: false });
    }
  }, [editor, isMobile]);
  const content = children ?? /* @__PURE__ */ jsx(DefaultStylePanelContent, { styles });
  return /* @__PURE__ */ jsx(
    "div",
    {
      className: classNames("tlui-style-panel", { "tlui-style-panel__wrapper": !isMobile }),
      "data-ismobile": isMobile,
      onPointerLeave: handlePointerOut,
      children: content
    }
  );
});
export {
  DefaultStylePanel
};
//# sourceMappingURL=DefaultStylePanel.mjs.map
