import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import {
  ArrowShapeArrowheadEndStyle,
  ArrowShapeArrowheadStartStyle,
  DefaultColorStyle,
  DefaultDashStyle,
  DefaultFillStyle,
  DefaultFontStyle,
  DefaultHorizontalAlignStyle,
  DefaultSizeStyle,
  DefaultTextAlignStyle,
  DefaultVerticalAlignStyle,
  GeoShapeGeoStyle,
  LineShapeSplineStyle,
  getDefaultColorTheme,
  minBy,
  useEditor,
  useIsDarkMode,
  useValue
} from "@tldraw/editor";
import React from "react";
import { STYLES } from "../../../styles.mjs";
import { kickoutOccludedShapes } from "../../../tools/SelectTool/selectHelpers.mjs";
import { useUiEvents } from "../../context/events.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
import { TldrawUiButtonPicker } from "../primitives/TldrawUiButtonPicker.mjs";
import { TldrawUiSlider } from "../primitives/TldrawUiSlider.mjs";
import { DoubleDropdownPicker } from "./DoubleDropdownPicker.mjs";
import { DropdownPicker } from "./DropdownPicker.mjs";
function DefaultStylePanelContent({ styles }) {
  const isDarkMode = useIsDarkMode();
  if (!styles) return null;
  const geo = styles.get(GeoShapeGeoStyle);
  const arrowheadEnd = styles.get(ArrowShapeArrowheadEndStyle);
  const arrowheadStart = styles.get(ArrowShapeArrowheadStartStyle);
  const spline = styles.get(LineShapeSplineStyle);
  const font = styles.get(DefaultFontStyle);
  const hideGeo = geo === void 0;
  const hideArrowHeads = arrowheadEnd === void 0 && arrowheadStart === void 0;
  const hideSpline = spline === void 0;
  const hideText = font === void 0;
  const theme = getDefaultColorTheme({ isDarkMode });
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(CommonStylePickerSet, { theme, styles }),
    !hideText && /* @__PURE__ */ jsx(TextStylePickerSet, { theme, styles }),
    !(hideGeo && hideArrowHeads && hideSpline) && /* @__PURE__ */ jsxs("div", { className: "tlui-style-panel__section", "aria-label": "style panel styles", children: [
      /* @__PURE__ */ jsx(GeoStylePickerSet, { styles }),
      /* @__PURE__ */ jsx(ArrowheadStylePickerSet, { styles }),
      /* @__PURE__ */ jsx(SplineStylePickerSet, { styles })
    ] })
  ] });
}
function useStyleChangeCallback() {
  const editor = useEditor();
  const trackEvent = useUiEvents();
  return React.useMemo(
    () => (function handleStyleChange(style, value) {
      editor.run(() => {
        if (editor.isIn("select")) {
          editor.setStyleForSelectedShapes(style, value);
        }
        editor.setStyleForNextShapes(style, value);
        editor.updateInstanceState({ isChangingStyle: true });
      });
      trackEvent("set-style", { source: "style-panel", id: style.id, value });
    }),
    [editor, trackEvent]
  );
}
function CommonStylePickerSet({ styles, theme }) {
  const msg = useTranslation();
  const editor = useEditor();
  const handleValueChange = useStyleChangeCallback();
  const color = styles.get(DefaultColorStyle);
  const fill = styles.get(DefaultFillStyle);
  const dash = styles.get(DefaultDashStyle);
  const size = styles.get(DefaultSizeStyle);
  const showPickers = fill !== void 0 || dash !== void 0 || size !== void 0;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(
      "div",
      {
        tabIndex: -1,
        className: "tlui-style-panel__section__common",
        "aria-label": "style panel styles",
        "data-testid": "style.panel",
        children: [
          color === void 0 ? null : /* @__PURE__ */ jsx(
            TldrawUiButtonPicker,
            {
              title: msg("style-panel.color"),
              uiType: "color",
              style: DefaultColorStyle,
              items: STYLES.color,
              value: color,
              onValueChange: handleValueChange,
              theme
            }
          ),
          /* @__PURE__ */ jsx(OpacitySlider, {})
        ]
      }
    ),
    showPickers && /* @__PURE__ */ jsxs("div", { className: "tlui-style-panel__section", "aria-label": "style panel styles", children: [
      fill === void 0 ? null : /* @__PURE__ */ jsx(
        TldrawUiButtonPicker,
        {
          title: msg("style-panel.fill"),
          uiType: "fill",
          style: DefaultFillStyle,
          items: STYLES.fill,
          value: fill,
          onValueChange: handleValueChange,
          theme
        }
      ),
      dash === void 0 ? null : /* @__PURE__ */ jsx(
        TldrawUiButtonPicker,
        {
          title: msg("style-panel.dash"),
          uiType: "dash",
          style: DefaultDashStyle,
          items: STYLES.dash,
          value: dash,
          onValueChange: handleValueChange,
          theme
        }
      ),
      size === void 0 ? null : /* @__PURE__ */ jsx(
        TldrawUiButtonPicker,
        {
          title: msg("style-panel.size"),
          uiType: "size",
          style: DefaultSizeStyle,
          items: STYLES.size,
          value: size,
          onValueChange: (style, value) => {
            handleValueChange(style, value);
            const selectedShapeIds = editor.getSelectedShapeIds();
            if (selectedShapeIds.length > 0) {
              kickoutOccludedShapes(editor, selectedShapeIds);
            }
          },
          theme
        }
      )
    ] })
  ] });
}
function TextStylePickerSet({ theme, styles }) {
  const msg = useTranslation();
  const handleValueChange = useStyleChangeCallback();
  const font = styles.get(DefaultFontStyle);
  const textAlign = styles.get(DefaultTextAlignStyle);
  const labelAlign = styles.get(DefaultHorizontalAlignStyle);
  const verticalLabelAlign = styles.get(DefaultVerticalAlignStyle);
  if (font === void 0 && labelAlign === void 0) {
    return null;
  }
  return /* @__PURE__ */ jsxs("div", { className: "tlui-style-panel__section", "aria-label": "style panel text", children: [
    font === void 0 ? null : /* @__PURE__ */ jsx(
      TldrawUiButtonPicker,
      {
        title: msg("style-panel.font"),
        uiType: "font",
        style: DefaultFontStyle,
        items: STYLES.font,
        value: font,
        onValueChange: handleValueChange,
        theme
      }
    ),
    textAlign === void 0 ? null : /* @__PURE__ */ jsxs("div", { className: "tlui-style-panel__row", children: [
      /* @__PURE__ */ jsx(
        TldrawUiButtonPicker,
        {
          title: msg("style-panel.align"),
          uiType: "align",
          style: DefaultTextAlignStyle,
          items: STYLES.textAlign,
          value: textAlign,
          onValueChange: handleValueChange,
          theme
        }
      ),
      /* @__PURE__ */ jsx("div", { className: "tlui-style-panel__row__extra-button", children: /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          title: msg("style-panel.vertical-align"),
          "data-testid": "vertical-align",
          disabled: true,
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "vertical-align-middle" })
        }
      ) })
    ] }),
    labelAlign === void 0 ? null : /* @__PURE__ */ jsxs("div", { className: "tlui-style-panel__row", children: [
      /* @__PURE__ */ jsx(
        TldrawUiButtonPicker,
        {
          title: msg("style-panel.align"),
          uiType: "align",
          style: DefaultHorizontalAlignStyle,
          items: STYLES.horizontalAlign,
          value: labelAlign,
          onValueChange: handleValueChange,
          theme
        }
      ),
      /* @__PURE__ */ jsx("div", { className: "tlui-style-panel__row__extra-button", children: verticalLabelAlign === void 0 ? /* @__PURE__ */ jsx(
        TldrawUiButton,
        {
          type: "icon",
          title: msg("style-panel.vertical-align"),
          "data-testid": "vertical-align",
          disabled: true,
          children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "vertical-align-middle" })
        }
      ) : /* @__PURE__ */ jsx(
        DropdownPicker,
        {
          type: "icon",
          id: "geo-vertical-alignment",
          uiType: "verticalAlign",
          style: DefaultVerticalAlignStyle,
          items: STYLES.verticalAlign,
          value: verticalLabelAlign,
          onValueChange: handleValueChange
        }
      ) })
    ] })
  ] });
}
function GeoStylePickerSet({ styles }) {
  const handleValueChange = useStyleChangeCallback();
  const geo = styles.get(GeoShapeGeoStyle);
  if (geo === void 0) {
    return null;
  }
  return /* @__PURE__ */ jsx(
    DropdownPicker,
    {
      id: "geo",
      type: "menu",
      label: "style-panel.geo",
      uiType: "geo",
      style: GeoShapeGeoStyle,
      items: STYLES.geo,
      value: geo,
      onValueChange: handleValueChange
    }
  );
}
function SplineStylePickerSet({ styles }) {
  const handleValueChange = useStyleChangeCallback();
  const spline = styles.get(LineShapeSplineStyle);
  if (spline === void 0) {
    return null;
  }
  return /* @__PURE__ */ jsx(
    DropdownPicker,
    {
      id: "spline",
      type: "menu",
      label: "style-panel.spline",
      uiType: "spline",
      style: LineShapeSplineStyle,
      items: STYLES.spline,
      value: spline,
      onValueChange: handleValueChange
    }
  );
}
function ArrowheadStylePickerSet({ styles }) {
  const handleValueChange = useStyleChangeCallback();
  const arrowheadEnd = styles.get(ArrowShapeArrowheadEndStyle);
  const arrowheadStart = styles.get(ArrowShapeArrowheadStartStyle);
  if (!arrowheadEnd || !arrowheadStart) {
    return null;
  }
  return /* @__PURE__ */ jsx(
    DoubleDropdownPicker,
    {
      label: "style-panel.arrowheads",
      uiTypeA: "arrowheadStart",
      styleA: ArrowShapeArrowheadStartStyle,
      itemsA: STYLES.arrowheadStart,
      valueA: arrowheadStart,
      uiTypeB: "arrowheadEnd",
      styleB: ArrowShapeArrowheadEndStyle,
      itemsB: STYLES.arrowheadEnd,
      valueB: arrowheadEnd,
      onValueChange: handleValueChange,
      labelA: "style-panel.arrowhead-start",
      labelB: "style-panel.arrowhead-end"
    }
  );
}
const tldrawSupportedOpacities = [0.1, 0.25, 0.5, 0.75, 1];
function OpacitySlider() {
  const editor = useEditor();
  const opacity = useValue("opacity", () => editor.getSharedOpacity(), [editor]);
  const trackEvent = useUiEvents();
  const msg = useTranslation();
  const handleOpacityValueChange = React.useCallback(
    (value) => {
      const item = tldrawSupportedOpacities[value];
      editor.run(() => {
        if (editor.isIn("select")) {
          editor.setOpacityForSelectedShapes(item);
        }
        editor.setOpacityForNextShapes(item);
        editor.updateInstanceState({ isChangingStyle: true });
      });
      trackEvent("set-style", { source: "style-panel", id: "opacity", value });
    },
    [editor, trackEvent]
  );
  if (opacity === void 0) return null;
  const opacityIndex = opacity.type === "mixed" ? -1 : tldrawSupportedOpacities.indexOf(
    minBy(
      tldrawSupportedOpacities,
      (supportedOpacity) => Math.abs(supportedOpacity - opacity.value)
    )
  );
  return /* @__PURE__ */ jsx(
    TldrawUiSlider,
    {
      "data-testid": "style.opacity",
      value: opacityIndex >= 0 ? opacityIndex : tldrawSupportedOpacities.length - 1,
      label: opacity.type === "mixed" ? "style-panel.mixed" : `opacity-style.${opacity.value}`,
      onValueChange: handleOpacityValueChange,
      steps: tldrawSupportedOpacities.length - 1,
      title: msg("style-panel.opacity")
    }
  );
}
export {
  ArrowheadStylePickerSet,
  CommonStylePickerSet,
  DefaultStylePanelContent,
  GeoStylePickerSet,
  OpacitySlider,
  SplineStylePickerSet,
  TextStylePickerSet
};
//# sourceMappingURL=DefaultStylePanelContent.mjs.map
