import { jsx } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import classNames from "classnames";
import { PORTRAIT_BREAKPOINT } from "../../constants.mjs";
import { useBreakpoint } from "../../context/breakpoints.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
function ToggleToolLockedButton({ activeToolId }) {
  const editor = useEditor();
  const breakpoint = useBreakpoint();
  const msg = useTranslation();
  const isToolLocked = useValue("is tool locked", () => editor.getInstanceState().isToolLocked, [
    editor
  ]);
  const tool = useValue("current tool", () => editor.getCurrentTool(), [editor]);
  if (!activeToolId || !tool.isLockable) return null;
  return /* @__PURE__ */ jsx(
    TldrawUiButton,
    {
      type: "normal",
      title: msg("action.toggle-tool-lock"),
      "data-testid": "tool-lock",
      className: classNames("tlui-toolbar__lock-button", {
        "tlui-toolbar__lock-button__mobile": breakpoint < PORTRAIT_BREAKPOINT.TABLET_SM
      }),
      onClick: () => editor.updateInstanceState({ isToolLocked: !isToolLocked }),
      children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: isToolLocked ? "lock" : "unlock", small: true })
    }
  );
}
export {
  ToggleToolLockedButton
};
//# sourceMappingURL=ToggleToolLockedButton.mjs.map
