import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useActions } from "../../context/actions.mjs";
import { ZoomTo100MenuItem, ZoomToFitMenuItem, ZoomToSelectionMenuItem } from "../menu-items.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
function DefaultZoomMenuContent() {
  const actions = useActions();
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-in"], noClose: true }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-out"], noClose: true }),
    /* @__PURE__ */ jsx(ZoomTo100MenuItem, {}),
    /* @__PURE__ */ jsx(ZoomToFitMenuItem, {}),
    /* @__PURE__ */ jsx(ZoomToSelectionMenuItem, {})
  ] });
}
export {
  DefaultZoomMenuContent
};
//# sourceMappingURL=DefaultZoomMenuContent.mjs.map
