import { jsx } from "react/jsx-runtime";
import {
  DefaultColorStyle,
  useEditor
} from "@tldraw/editor";
import classNames from "classnames";
import { memo, useMemo, useRef } from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "./Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "./Button/TldrawUiButtonIcon.mjs";
const TldrawUiButtonPicker = memo(function TldrawUiButtonPicker2(props) {
  const {
    uiType,
    items,
    title,
    style,
    value,
    // columns = clamp(items.length, 2, 4),
    onValueChange,
    theme
  } = props;
  const editor = useEditor();
  const msg = useTranslation();
  const rPointing = useRef(false);
  const rPointingOriginalActiveElement = useRef(null);
  const {
    handleButtonClick,
    handleButtonPointerDown,
    handleButtonPointerEnter,
    handleButtonPointerUp
  } = useMemo(() => {
    const handlePointerUp = () => {
      rPointing.current = false;
      window.removeEventListener("pointerup", handlePointerUp);
      const origActiveEl = rPointingOriginalActiveElement.current;
      if (origActiveEl && ["TEXTAREA", "INPUT"].includes(origActiveEl.nodeName)) {
        origActiveEl.focus();
      }
      rPointingOriginalActiveElement.current = null;
    };
    const handleButtonClick2 = (e) => {
      const { id } = e.currentTarget.dataset;
      if (value.type === "shared" && value.value === id) return;
      editor.mark("point picker item");
      onValueChange(style, id);
    };
    const handleButtonPointerDown2 = (e) => {
      const { id } = e.currentTarget.dataset;
      editor.mark("point picker item");
      onValueChange(style, id);
      rPointing.current = true;
      rPointingOriginalActiveElement.current = document.activeElement;
      window.addEventListener("pointerup", handlePointerUp);
    };
    const handleButtonPointerEnter2 = (e) => {
      if (!rPointing.current) return;
      const { id } = e.currentTarget.dataset;
      onValueChange(style, id);
    };
    const handleButtonPointerUp2 = (e) => {
      const { id } = e.currentTarget.dataset;
      if (value.type === "shared" && value.value === id) return;
      onValueChange(style, id);
    };
    return {
      handleButtonClick: handleButtonClick2,
      handleButtonPointerDown: handleButtonPointerDown2,
      handleButtonPointerEnter: handleButtonPointerEnter2,
      handleButtonPointerUp: handleButtonPointerUp2
    };
  }, [value, editor, onValueChange, style]);
  return /* @__PURE__ */ jsx("div", { "data-testid": `style.${uiType}`, className: classNames("tlui-buttons__grid"), children: items.map((item) => /* @__PURE__ */ jsx(
    TldrawUiButton,
    {
      type: "icon",
      "data-id": item.value,
      "data-testid": `style.${uiType}.${item.value}`,
      "aria-label": item.value,
      "data-state": value.type === "shared" && value.value === item.value ? "hinted" : void 0,
      title: title + " \u2014 " + msg(`${uiType}-style.${item.value}`),
      className: classNames("tlui-button-grid__button"),
      style: style === DefaultColorStyle ? { color: theme[item.value].solid } : void 0,
      onPointerEnter: handleButtonPointerEnter,
      onPointerDown: handleButtonPointerDown,
      onPointerUp: handleButtonPointerUp,
      onClick: handleButtonClick,
      children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: item.icon })
    },
    item.value
  )) });
});
export {
  TldrawUiButtonPicker
};
//# sourceMappingURL=TldrawUiButtonPicker.mjs.map
