import { jsx } from "react/jsx-runtime";
import * as _Dialog from "@radix-ui/react-dialog";
import classNames from "classnames";
import { TldrawUiButton } from "./Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "./Button/TldrawUiButtonIcon.mjs";
function TldrawUiDialogHeader({ className, children }) {
  return /* @__PURE__ */ jsx("div", { className: classNames("tlui-dialog__header", className), children });
}
function TldrawUiDialogTitle({ className, children }) {
  return /* @__PURE__ */ jsx(_Dialog.DialogTitle, { dir: "ltr", className: classNames("tlui-dialog__header__title", className), children });
}
function TldrawUiDialogCloseButton() {
  return /* @__PURE__ */ jsx("div", { className: "tlui-dialog__header__close", children: /* @__PURE__ */ jsx(_Dialog.DialogClose, { "data-testid": "dialog.close", dir: "ltr", asChild: true, children: /* @__PURE__ */ jsx(
    TldrawUiButton,
    {
      type: "icon",
      "aria-label": "Close",
      onTouchEnd: (e) => e.target.click(),
      children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { small: true, icon: "cross-2" })
    }
  ) }) });
}
function TldrawUiDialogBody({ className, children, style }) {
  return /* @__PURE__ */ jsx("div", { className: classNames("tlui-dialog__body", className), style, children });
}
function TldrawUiDialogFooter({ className, children }) {
  return /* @__PURE__ */ jsx("div", { className: classNames("tlui-dialog__footer", className), children });
}
export {
  TldrawUiDialogBody,
  TldrawUiDialogCloseButton,
  TldrawUiDialogFooter,
  TldrawUiDialogHeader,
  TldrawUiDialogTitle
};
//# sourceMappingURL=TldrawUiDialog.mjs.map
