import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import { memo, useLayoutEffect, useRef } from "react";
import { useAssetUrls } from "../../context/asset-urls.mjs";
const TldrawUiIcon = memo(function TldrawUiIcon2({
  small,
  invertIcon,
  icon,
  color,
  className,
  ...props
}) {
  const assetUrls = useAssetUrls();
  const asset = assetUrls.icons[icon] ?? assetUrls.icons["question-mark-circle"];
  const ref = useRef(null);
  useLayoutEffect(() => {
    if (!asset) {
      console.error(`Icon not found: ${icon}. Add it to the assetUrls.icons object.`);
    }
    if (ref?.current) {
      ref.current.style.webkitMask = `url(${asset}) center 100% / 100% no-repeat`;
    }
  }, [ref, asset, icon]);
  if (icon === "none") {
    return /* @__PURE__ */ jsx(
      "div",
      {
        className: classNames(
          "tlui-icon tlui-icon__placeholder",
          { "tlui-icon__small": small },
          className
        )
      }
    );
  }
  return /* @__PURE__ */ jsx(
    "div",
    {
      ...props,
      ref,
      className: classNames("tlui-icon", { "tlui-icon__small": small }, className),
      style: {
        color,
        mask: `url(${asset}) center 100% / 100% no-repeat`,
        transform: invertIcon ? "scale(-1, 1)" : void 0
      }
    }
  );
});
export {
  TldrawUiIcon
};
//# sourceMappingURL=TldrawUiIcon.mjs.map
