import { jsx, jsxs } from "react/jsx-runtime";
import * as _ContextMenu from "@radix-ui/react-context-menu";
import * as _DropdownMenu from "@radix-ui/react-dropdown-menu";
import { preventDefault } from "@tldraw/editor";
import { unwrapLabel } from "../../../context/actions.mjs";
import { useReadonly } from "../../../hooks/useReadonly.mjs";
import { useTranslation } from "../../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiIcon } from "../TldrawUiIcon.mjs";
import { TldrawUiKbd } from "../TldrawUiKbd.mjs";
import { useTldrawUiMenuContext } from "./TldrawUiMenuContext.mjs";
function TldrawUiMenuCheckboxItem({
  id,
  kbd,
  label,
  readonlyOk,
  onSelect,
  toggle = false,
  disabled = false,
  checked = false
}) {
  const { type: menuType, sourceId } = useTldrawUiMenuContext();
  const isReadonlyMode = useReadonly();
  const msg = useTranslation();
  if (isReadonlyMode && !readonlyOk) return null;
  const labelToUse = unwrapLabel(label, menuType);
  const labelStr = labelToUse ? msg(labelToUse) : void 0;
  switch (menuType) {
    case "menu": {
      return /* @__PURE__ */ jsxs(
        _DropdownMenu.CheckboxItem,
        {
          dir: "ltr",
          className: "tlui-button tlui-button__menu tlui-button__checkbox",
          title: labelStr,
          onSelect: (e) => {
            onSelect?.(sourceId);
            preventDefault(e);
          },
          disabled,
          checked,
          children: [
            /* @__PURE__ */ jsx(
              TldrawUiIcon,
              {
                small: true,
                icon: toggle ? checked ? "toggle-on" : "toggle-off" : checked ? "check" : "none"
              }
            ),
            labelStr && /* @__PURE__ */ jsx("span", { className: "tlui-button__label", draggable: false, children: labelStr }),
            kbd && /* @__PURE__ */ jsx(TldrawUiKbd, { children: kbd })
          ]
        }
      );
    }
    case "context-menu": {
      return /* @__PURE__ */ jsxs(
        _ContextMenu.CheckboxItem,
        {
          className: "tlui-button tlui-button__menu tlui-button__checkbox",
          dir: "ltr",
          title: labelStr,
          onSelect: (e) => {
            onSelect(sourceId);
            preventDefault(e);
          },
          disabled,
          checked,
          children: [
            /* @__PURE__ */ jsx(
              TldrawUiIcon,
              {
                small: true,
                icon: toggle ? checked ? "toggle-on" : "toggle-off" : checked ? "check" : "none"
              }
            ),
            labelStr && /* @__PURE__ */ jsx("span", { className: "tlui-button__label", draggable: false, children: labelStr }),
            kbd && /* @__PURE__ */ jsx(TldrawUiKbd, { children: kbd })
          ]
        },
        id
      );
    }
    default: {
      return null;
    }
  }
}
export {
  TldrawUiMenuCheckboxItem
};
//# sourceMappingURL=TldrawUiMenuCheckboxItem.mjs.map
