import { jsx, jsxs } from "react/jsx-runtime";
import { ContextMenuGroup } from "@radix-ui/react-context-menu";
import { unwrapLabel } from "../../../context/actions.mjs";
import { useTranslation } from "../../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiDropdownMenuGroup } from "../TldrawUiDropdownMenu.mjs";
import { useTldrawUiMenuContext } from "./TldrawUiMenuContext.mjs";
function TldrawUiMenuGroup({ id, label, children }) {
  const { type: menuType, sourceId } = useTldrawUiMenuContext();
  const msg = useTranslation();
  const labelToUse = unwrapLabel(label, menuType);
  const labelStr = labelToUse ? msg(labelToUse) : void 0;
  switch (menuType) {
    case "panel": {
      return /* @__PURE__ */ jsx("div", { className: "tlui-menu__group", "data-testid": `${sourceId}-group.${id}`, children });
    }
    case "menu": {
      return /* @__PURE__ */ jsx(TldrawUiDropdownMenuGroup, { "data-testid": `${sourceId}-group.${id}`, children });
    }
    case "context-menu": {
      return /* @__PURE__ */ jsx(
        ContextMenuGroup,
        {
          dir: "ltr",
          className: "tlui-menu__group",
          "data-testid": `${sourceId}-group.${id}`,
          children
        }
      );
    }
    case "keyboard-shortcuts": {
      return /* @__PURE__ */ jsxs("div", { className: "tlui-shortcuts-dialog__group", "data-testid": `${sourceId}-group.${id}`, children: [
        /* @__PURE__ */ jsx("h2", { className: "tlui-shortcuts-dialog__group__title", children: labelStr }),
        /* @__PURE__ */ jsx("div", { className: "tlui-shortcuts-dialog__group__content", children })
      ] });
    }
    default: {
      return children;
    }
  }
}
export {
  TldrawUiMenuGroup
};
//# sourceMappingURL=TldrawUiMenuGroup.mjs.map
