import { DEFAULT_SUPPORTED_MEDIA_TYPE_LIST, useEditor } from "@tldraw/editor";
import { useCallback, useEffect, useRef } from "react";
function useInsertMedia() {
  const editor = useEditor();
  const inputRef = useRef();
  useEffect(() => {
    const input = window.document.createElement("input");
    input.type = "file";
    input.accept = DEFAULT_SUPPORTED_MEDIA_TYPE_LIST;
    input.multiple = true;
    inputRef.current = input;
    async function onchange(e) {
      const fileList = e.target.files;
      if (!fileList || fileList.length === 0) return;
      editor.mark("insert media");
      await editor.putExternalContent({
        type: "files",
        files: Array.from(fileList),
        point: editor.getViewportPageBounds().center,
        ignoreParent: false
      });
      input.value = "";
    }
    input.addEventListener("change", onchange);
    return () => {
      inputRef.current = void 0;
      input.removeEventListener("change", onchange);
    };
  }, [editor]);
  return useCallback(() => {
    inputRef.current?.click();
  }, [inputRef]);
}
export {
  useInsertMedia
};
//# sourceMappingURL=useInsertMedia.mjs.map
