import { useEffect, useMemo, useState } from "react";
import { preloadFont } from "../../utils/assets/preload-font.mjs";
var PreloadStatus = /* @__PURE__ */ ((PreloadStatus2) => {
  PreloadStatus2[PreloadStatus2["SUCCESS"] = 0] = "SUCCESS";
  PreloadStatus2[PreloadStatus2["FAILED"] = 1] = "FAILED";
  PreloadStatus2[PreloadStatus2["WAITING"] = 2] = "WAITING";
  return PreloadStatus2;
})(PreloadStatus || {});
const usePreloadFont = (id, font) => {
  const [state, setState] = useState(2 /* WAITING */);
  useEffect(() => {
    let cancelled = false;
    setState(2 /* WAITING */);
    preloadFont(id, font).then(() => {
      if (cancelled) return;
      setState(0 /* SUCCESS */);
    }).catch((err) => {
      if (cancelled) return;
      console.error(err);
      setState(1 /* FAILED */);
    });
    return () => {
      cancelled = true;
    };
  }, [id, font]);
  return state;
};
function getTypefaces(assetUrls) {
  return {
    draw: {
      url: assetUrls.fonts.draw,
      format: assetUrls.fonts.draw.split(".").pop()
    },
    serif: {
      url: assetUrls.fonts.serif,
      format: assetUrls.fonts.serif.split(".").pop()
    },
    sansSerif: {
      url: assetUrls.fonts.sansSerif,
      format: assetUrls.fonts.sansSerif.split(".").pop()
    },
    monospace: {
      url: assetUrls.fonts.monospace,
      format: assetUrls.fonts.monospace.split(".").pop()
    }
  };
}
function usePreloadAssets(assetUrls) {
  const typefaces = useMemo(() => getTypefaces(assetUrls), [assetUrls]);
  const results = [
    usePreloadFont("tldraw_draw", typefaces.draw),
    usePreloadFont("tldraw_serif", typefaces.serif),
    usePreloadFont("tldraw_sans", typefaces.sansSerif),
    usePreloadFont("tldraw_mono", typefaces.monospace)
  ];
  return {
    // If any of the results have errored, then preloading has failed
    error: results.some((result) => result === 1 /* FAILED */),
    // If any of the results are waiting, then we're not done yet
    done: !results.some((result) => result === 2 /* WAITING */)
  };
}
export {
  usePreloadAssets
};
//# sourceMappingURL=usePreloadAssets.mjs.map
